<?php
include 'db.php';

$office_name = "COLLATE ENTERPRISES";
$office_mobile = "+255 712 345 678";

$assignment_id = isset($_GET['assignment_id']) ? intval($_GET['assignment_id']) : 0;

if (!$assignment_id) die("Invalid assignment ID.");

// Fetch assignment details
$stmt = $conn->prepare("
    SELECT a.id, a.worker_name, a.task, a.agreed_amount, a.amount_paid, p.name AS project_name
    FROM assignments a
    LEFT JOIN projects p ON a.project_id = p.id
    WHERE a.id = ?
");
$stmt->bind_param("i", $assignment_id);
$stmt->execute();
$assignment = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$assignment) die("Assignment not found.");

// Fetch payments
$payments = [];
$stmt = $conn->prepare("SELECT * FROM assignment_payments WHERE assignment_id = ? ORDER BY id ASC");
$stmt->bind_param("i", $assignment_id);
$stmt->execute();
$res = $stmt->get_result();
while ($row = $res->fetch_assoc()) $payments[] = $row;
$stmt->close();
?>

<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Payment Report</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
@media print {
    .no-print { display: none; }
    .header-print, .footer-print {
        width: 100%;
        text-align: center;
        position: fixed;
    }
    .header-print { top: 0; }
    .footer-print { bottom: 0; font-size: 0.9em; }
    body { margin-top: 100px; margin-bottom: 60px; }
    table { page-break-inside: auto; }
    tr { page-break-inside: avoid; page-break-after: auto; }
}
</style>
</head>
<body class="container py-4">

<!-- Print Button -->
<div class="d-flex justify-content-between align-items-center mb-4 no-print">
    <h2>Payment Report</h2>
    <button class="btn btn-primary" onclick="window.print()">🖨 Print Report</button>
</div>

<!-- Company Header for Print -->
<div class="header-print">
    <h2><?= htmlspecialchars($office_name) ?></h2>
    <p>Mobile: <?= htmlspecialchars($office_mobile) ?></p>
    <hr>
</div>

<!-- Assignment Details -->
<div class="mb-3">
    <p><strong>Project:</strong> <?= htmlspecialchars($assignment['project_name']) ?> (#<?= $assignment['id'] ?>)</p>
    <p><strong>Fundi:</strong> <?= htmlspecialchars($assignment['worker_name']) ?></p>
    <p><strong>Task:</strong> <?= htmlspecialchars($assignment['task']) ?></p>
    <p><strong>Agreed Amount:</strong> Tshs. <?= number_format($assignment['agreed_amount'],2) ?></p>
    <p><strong>Total Paid:</strong> Tshs. <?= number_format($assignment['amount_paid'],2) ?></p>
    <p><strong>Balance:</strong> Tshs. <?= number_format($assignment['agreed_amount'] - $assignment['amount_paid'],2) ?></p>
</div>

<!-- Payments Table -->
<table class="table table-bordered table-striped">
<thead class="table-dark">
<tr>
    <th>#</th>
    <th>Payment Date</th>
    <th>Amount</th>
    <th>Reference</th>
</tr>
</thead>
<tbody>
<?php if(count($payments) > 0): ?>
    <?php foreach($payments as $i => $payment): ?>
    <tr>
        <td><?= $i+1 ?></td>
        <td><?= htmlspecialchars($payment['payment_date'] ?? 'N/A') ?></td>
        <td>Tshs. <?= number_format($payment['amount'] ?? 0,2) ?></td>
        <td><?= htmlspecialchars($payment['reference'] ?? 'Cash') ?></td>
    </tr>
    <?php endforeach; ?>
<?php else: ?>
<tr>
    <td colspan="4" class="text-center">No payments recorded yet.</td>
</tr>
<?php endif; ?>
</tbody>
</table>

<!-- Footer for Print -->
<div class="footer-print">
    <hr>
    <p>Printed on: <?= date('d-m-Y H:i') ?> | Fundi: <?= htmlspecialchars($assignment['worker_name']) ?></p>
</div>

<div class="mt-4 no-print">
    <a href="assignments.php" class="btn btn-secondary">Back to Assignments</a>
</div>

</body>
</html>
