<?php
include 'db.php';

if (!isset($_GET['project_id']) || empty($_GET['project_id'])) {
    die("<script>alert('Project ID is missing!');window.close();</script>");
}

$project_id = (int)$_GET['project_id'];

// ===== Get Project Info =====
$project_stmt = $conn->prepare("SELECT * FROM projects WHERE id = ?");
$project_stmt->bind_param("i", $project_id);
$project_stmt->execute();
$project = $project_stmt->get_result()->fetch_assoc();
$project_stmt->close();

if (!$project) {
    die("<script>alert('Project not found!');window.close();</script>");
}

// ===== Get Payments =====
$payments_res = $conn->query("SELECT * FROM payments WHERE project_id = $project_id ORDER BY payment_date ASC");

// ===== Get Allocated Budget =====
$budget_res = $conn->query("SELECT allocated FROM budgets WHERE project_id = $project_id");
$budget_row = $budget_res->fetch_assoc();
$allocated = $budget_row ? floatval($budget_row['allocated']) : 0.00;

// ===== Totals =====
$total_paid = 0;
while ($row = $payments_res->fetch_assoc()) {
    $total_paid += floatval($row['amount']);
}
$payments_res->data_seek(0); // rewind pointer for reuse
$remaining = $allocated - $total_paid;
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Owner Payment Report</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background: #fff; font-size: 14px; }
@media print {
    .no-print { display: none; }
    body { background: #fff; }
}
.table th, .table td {
    vertical-align: middle !important;
}
</style>
</head>
<body class="p-4">

<div class="container">
    <div class="text-center mb-4">
        <h3 class="fw-bold text-uppercase">Owner Payment Report</h3>
        <p class="text-muted">As of <?= date('d M Y') ?></p>
    </div>

    <div class="card mb-4">
        <div class="card-body">
            <h5 class="mb-3 text-primary"><?= htmlspecialchars($project['name']) ?></h5>
            <p><strong>Owner:</strong> <?= htmlspecialchars($project['owner_name']) ?></p>
            <p><strong>Description:</strong> <?= nl2br(htmlspecialchars($project['description'])) ?></p>
            <p><strong>Duration:</strong> <?= htmlspecialchars($project['start_date']) ?> → <?= htmlspecialchars($project['end_date']) ?></p>
            <p><strong>Allocated Budget:</strong> <?= number_format($allocated,2) ?> TZS</p>
        </div>
    </div>

    <h5 class="text-secondary">Payment History</h5>
    <table class="table table-bordered">
        <thead class="table-dark">
            <tr>
                <th>#</th>
                <th>Date</th>
                <th class="text-end">Amount (TZS)</th>
            </tr>
        </thead>
        <tbody>
        <?php if ($payments_res->num_rows > 0): $sn=1; while($p = $payments_res->fetch_assoc()): ?>
            <tr>
                <td><?= $sn++ ?></td>
                <td><?= htmlspecialchars($p['payment_date']) ?></td>
                <td class="text-end"><?= number_format(floatval($p['amount']),2) ?></td>
            </tr>
        <?php endwhile; else: ?>
            <tr><td colspan="3" class="text-center"><em>No payments recorded.</em></td></tr>
        <?php endif; ?>
        </tbody>
        <tfoot class="table-light">
            <tr>
                <th colspan="2" class="text-end">Total Paid:</th>
                <th class="text-end"><?= number_format($total_paid,2) ?></th>
            </tr>
            <tr>
                <th colspan="2" class="text-end">Remaining Balance:</th>
                <th class="text-end"><?= number_format($remaining,2) ?></th>
            </tr>
        </tfoot>
    </table>

    <div class="text-center mt-4 no-print">
        <button onclick="window.print()" class="btn btn-primary">🖨️ Print Report</button>
        <a href="budgets.php" class="btn btn-secondary">⬅ Back</a>
    </div>
</div>

</body>
</html>
