<?php
include 'db.php';

$page = isset($_GET['page']) ? intval($_GET['page']) : 1;
$limit = isset($_GET['limit']) ? intval($_GET['limit']) : 10;
$search = isset($_GET['search']) ? $_GET['search'] : '';

$offset = ($page - 1) * $limit;

$where = '';
$params = [];
$types = '';

if(!empty($search)){
    $where = "WHERE p.name LIKE ? OR a.worker_name LIKE ?";
    $searchTerm = "%$search%";
    $params = [$searchTerm, $searchTerm];
    $types = "ss";
}

// Count total rows
$totalQuery = "SELECT COUNT(*) as total FROM assignments a LEFT JOIN projects p ON a.project_id=p.id $where";
$stmtTotal = $conn->prepare($totalQuery);
if(!empty($where)){
    $stmtTotal->bind_param($types, ...$params);
}
$stmtTotal->execute();
$resultTotal = $stmtTotal->get_result()->fetch_assoc();
$totalRows = $resultTotal['total'];
$stmtTotal->close();

$totalPages = ceil($totalRows / $limit);

// Fetch paginated results
$dataQuery = "SELECT a.*, p.name AS project_name FROM assignments a LEFT JOIN projects p ON a.project_id=p.id $where ORDER BY a.id DESC LIMIT ?, ?";
$stmtData = $conn->prepare($dataQuery);

if(!empty($where)){
    $stmtData->bind_param($types . "ii", ...$params, $offset, $limit);
} else {
    $stmtData->bind_param("ii", $offset, $limit);
}

$stmtData->execute();
$result = $stmtData->get_result();

$html = '';
$sn = $offset + 1;
while($a = $result->fetch_assoc()){
    $balance = $a['agreed_amount'] - $a['amount_paid'];
    $id = $a['id'];

    $html .= '<tr>
<td>'.$sn++.'</td>
<td>'.htmlspecialchars($a['project_name']).' (#'.$a['project_id'].')</td>
<td>'.htmlspecialchars($a['worker_name']).'</td>
<td>'.htmlspecialchars($a['task']).'</td>
<td>Tshs. '.number_format($a['agreed_amount'],2).'</td>
<td>Tshs. '.number_format($a['amount_paid'],2).'</td>
<td>Tshs. '.number_format($balance,2).'</td>
<td>'.$a['progress'].'%</td>
<td>
<div class="dropdown">
<button type="button" class="btn btn-light btn-sm border-0 dropdown-toggle">&#8942;</button>
<ul class="dropdown-menu dropdown-menu-end">
<li><a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#progressModal'.$id.'">Update Progress</a></li>
<li><a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#paymentModal'.$id.'">Make Payment</a></li>
<li><a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#viewModal'.$id.'">View</a></li>
<li><a class="dropdown-item text-danger" data-bs-toggle="modal" data-bs-target="#deleteModal'.$id.'">Delete</a></li>
</ul>
</div>
</td>
</tr>';
}

$stmtData->close();

// Pagination HTML
$pagination = '';
if($totalPages > 1){
    $pagination .= '<nav><ul class="pagination">';
    for($i=1;$i<=$totalPages;$i++){
        $active = ($i==$page)?' active':'';
        $pagination .= '<li class="page-item'.$active.'"><a href="#" class="page-link" data-page="'.$i.'">'.$i.'</a></li>';
    }
    $pagination .= '</ul></nav>';
}

echo json_encode(['html'=>$html,'pagination'=>$pagination]);
