<?php
session_start();
if (!isset($_SESSION['username'])) {
    echo "<script>window.top.location.href='index.php';</script>"; // Redirect parent window to login page
    exit();
}

include 'connect.php';

// Angalia kama kuna ID ya bidhaa kwenye URL
if (isset($_GET['viewid'])) {
    $product_id = mysqli_real_escape_string($conn, $_GET['viewid']);

    // Pata maelezo ya bidhaa kutoka kwenye database
    $sql = "SELECT * FROM products_table WHERE product_id = '$product_id'";
    $result = mysqli_query($conn, $sql);

    if ($result && mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
    } else {
        echo "<h3 class='text-danger'>Product not found.</h3>";
        exit;
    }
} else {
    echo "<h3 class='text-danger'>Invalid Product ID.</h3>";
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/bootstrap.rtl.min.css">
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="fontawesome/css/all.min.css">
    <title>View Product</title>
</head>
<body>
<div class="container my-5">
    <h2 class="mb-4">Product Details</h2>
    
    <table class="table table-bordered">
        <tr>
            <th>Product Name</th>
            <td><?php echo $row['pr_Name']; ?></td>
        </tr>
        <tr>
            <th>Product Code</th>
            <td><?php echo $row['product_number']; ?></td>
        </tr>
        <tr>
            <th>Product Price</th>
            <td><?php echo number_format($row['pr_Price']); ?></td>
        </tr>
        <tr>
            <th>Product Cost</th>
            <td><?php echo number_format($row['pr_Cost']); ?></td>
        </tr>
        <tr>
            <th>Stock</th>
            <td><?php echo $row['qty_Onhand']; ?></td>
        </tr>
    </table>

    <a href="displayproducts.php" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> Back</a>
</div>
</body>
</html>
