<?php
// process_form.php

// Database connection
$host = 'localhost';  // Your server (localhost if it's local)
$username = 'root';   // Database username
$password = '';       // Database password
$dbname = 'prodb';    // Database name

$conn = new mysqli($host, $username, $password, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Get the form data
$service_name = $_POST['service_name'];  // The selected service name ID
$amount = $_POST['amount'];  // The amount of the selected service
$quantity = $_POST['quantity'];  // Quantity entered by the user
$date_provided = $_POST['date_provided'];  // Date of the service

// Calculate the total amount charged
$total_amount = $amount * $quantity;

// Prepare the SQL query to insert the data into the services table
// Using prepared statements to prevent SQL injection
$stmt = $conn->prepare("INSERT INTO services (service_name, amount, quantity, total_amount, date_provided) 
                        VALUES (?, ?, ?, ?, ?)");

// Bind parameters to the prepared statement
$stmt->bind_param("sdids", $service_name, $amount, $quantity, $total_amount, $date_provided);

// Execute the query
if ($stmt->execute()) {
    echo "Service recorded successfully!";
} else {
    echo "Error: " . $stmt->error;
}

// Close the statement and connection
$stmt->close();
$conn->close();
?>
