<?php
session_start();

// Check if user is logged in
if (!isset($_SESSION['username'])) {
    header("Location: index.php");
    exit();
}

// Display username or other content
$username = $_SESSION['username'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LAMILE HARDWARE</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-LN+7fdVzj6u52u30Kp6M/trliBMCMKTyK833zpbD+pXdCLuTusPj697FH4R/5mcr" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
    <link rel="stylesheet" href="stile.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

</head>
<body>
    
    <div class="sidebar">
        <nav class="nav flex-column">
            <a class="nav-link" href="top_products_chart.php" target="iframe_a">
                <span class="icon">
                    <i class="bi bi-grid"></i>
                </span>
                <span class="description">Dashboard</span>

            </a>

            <!--products menu with dropdown-->
            <a class="nav-link" href="#" target="iframe_a" data-bs-toggle="collapse" data-bs-target="#submenu4" aria-expanded="false" aria-controls="submenu4">
                <span class="icon">
                    <i class="bi bi-cart"></i>
                </span>
                <span class="description">Products <i class="bi bi-caret-down-fill"></i></span>
            </a>
            <!--submenu for products-->
            <div class="sub-menu collapse" id="submenu4">
                <a class="nav-link" href="insproducts.php" target="iframe_a">
                    <span class="icon">
                        <i class="bi bi-box"></i>
                    </span>
                    <span class="description">Create Products</span>

                </a>
                <a class="nav-link" href="displayproducts.php" target="iframe_a">
                    <span class="icon">
                        <i class="bi bi-collection"></i>
                    </span>
                    <span class="description">Product Lists</span>

                </a>
                <!--End of products sub menu-->
            </div>
       

            <!--expense menu with dropdown-->
            <a class="nav-link" href="#" data-page="" data-bs-toggle="collapse" data-bs-target="#submenu3" aria-expanded="false" aria-controls="submenu3">
                <span class="icon">
                    <i class="bi bi-credit-card"></i>
                </span>
                <span class="description">Expense <i class="bi bi-caret-down-fill"></i></span>
            </a>
            <!--submenu for expenses-->
            <div class="sub-menu collapse" id="submenu3">
                <a class="nav-link" href="insertexpense.php" target="iframe_a">
                    <span class="icon">
                        <i class="bi bi-arrow-down-circle"></i>
                    </span>
                    <span class="description">Create Expense</span>

                </a>
                <a class="nav-link" href="displayexpense.php" target="iframe_a">
                    <span class="icon">
                        <i class="bi bi-receipt"></i>
                    </span>
                    <span class="description">Expenses List</span>

                </a>
                <!--End of expense sub menu-->
            </div>

            <!--purchase menu with dropdown-->
            <a class="nav-link" href="#" data-bs-toggle="collapse" data-bs-target="#submenu5" aria-expanded="false" aria-controls="submenu5">
                <span class="icon">
                    <i class="bi bi-bag"></i>
                </span>
                <span class="description">Purchase <i class="bi bi-caret-down-fill"></i></span>
            </a>
            <!--submenu for purchase-->
            <div class="sub-menu collapse" id="submenu5">
                <a class="nav-link" href="purchase.php" target="iframe_a">
                    <span class="icon">
                        <i class="bi bi-cart-plus"></i>
                    </span>
                    <span class="description">Create Purchase</span>

                </a>
                <a class="nav-link" href="viewpurchases.php" target="iframe_a">
                    <span class="icon">
                        <i class="bi bi-receipt"></i>
                    </span>
                    <span class="description">Purchase Lists (All)</span>

                </a>
                <a class="nav-link" href="viewpurchasescredit.php" target="iframe_a">
                    <span class="icon">
                        <i class="bi bi-tag-fill"></i>
                    </span>
                    <span class="description">Purchase Lists (Cr)</span>

                </a>
                <!--End of purchase sub menu-->
            </div>


             <!--sales menu with dropdown-->
            <a class="nav-link" href="#" data-bs-toggle="collapse" data-bs-target="#submenu6" aria-expanded="false" aria-controls="submenu6">
                <span class="icon">
                    <i class="bi bi-currency-dollar"></i>
                </span>
                <span class="description">Sales <i class="bi bi-caret-down-fill"></i></span>
            </a>
            <!--submenu for sales-->
            <div class="sub-menu collapse" id="submenu6">
                <a class="nav-link" href="sell.php" target="iframe_a">
                    <span class="icon">
                        <i class="bi bi-cart-check"></i>
                    </span>
                    <span class="description">Create Sale</span>

                </a>
                <a class="nav-link" href="viewsells.php" target="iframe_a">
                    <span class="icon">
                        <i class="bi bi-trophy"></i>
                    </span>
                    <span class="description">Sales List (All)</span>

                </a>
                <a class="nav-link" href="viewsellscredit.php" target="iframe_a">
                    <span class="icon">
                        <i class="bi bi-bag-check"></i>
                    </span>
                    <span class="description">Sales List (Cr)</span>

                </a>

                <a class="nav-link" href="deletesale.php" target="iframe_a">
                    <span class="icon">
                        <i class="bi bi-x"></i>
                    </span>
                    <span class="description">Delete Sale</span>

                </a>
                <!--End of sales sub menu-->
            </div>

<!-- start of Products adjustments-->

            <a class="nav-link" href="#" data-bs-toggle="collapse" data-bs-target="#submenu17" aria-expanded="false" aria-controls="submenu6">
                <span class="icon">
                    <i class="bi bi-bar-chart-line"></i>
                </span>
                <span class="description">Adjustments <i class="bi bi-caret-down-fill"></i></span>
            </a>
            <!--submenu for Adjustments-->
            <div class="sub-menu collapse" id="submenu17">
                <a class="nav-link" href="adjust_stock.php" target="iframe_a">
                    <span class="icon">
                        <i class="bi bi-pencil-square"></i>
                    </span>
                    <span class="description">Create Adjustment</span>

                </a>
                <a class="nav-link" href="list_adjustment.php" target="iframe_a">
                    <span class="icon">
                        <i class="bi bi-list"></i>
                    </span>
                    <span class="description">List Adjustments</span>

                </a>
                
                <!--End of adjustments sub menu-->
            </div>





<!-- End of products adjustment -->


            
              <!--people menu with dropdown-->
            <a class="nav-link" href="#" data-bs-toggle="collapse" data-bs-target="#submenu7" aria-expanded="false" aria-controls="submenu7">
                <span class="icon">
                    <i class="bi bi-people"></i>
                </span>
                <span class="description">People <i class="bi bi-caret-down-fill"></i></span>
            </a>
            <!--submenu for sales-->
            <div class="sub-menu collapse" id="submenu7">
                <a class="nav-link" href="display.php" target="iframe_a">
                    <span class="icon">
                        <i class="bi bi-person-gear"></i>
                    </span>
                    <span class="description">Users List</span>

                </a>
                <a class="nav-link" href="display_customer.php" target="iframe_a">
                    <span class="icon">
                        <i class="bi bi-person-badge"></i>
                    </span>
                    <span class="description">Customers List</span>

                </a>
                <a class="nav-link" href="display_supplier.php" target="iframe_a">
                    <span class="icon">
                        <i class="bi bi-person-vcard"></i>
                    </span>
                    <span class="description">Suppliers List</span>

                </a>

                <!--End of people sub menu-->
            </div>



            <!--Reports menu with dropdown-->
            <a class="nav-link" href="#" data-bs-toggle="collapse" data-bs-target="#submenu8" aria-expanded="false" aria-controls="submenu8">
                <span class="icon">
                    <i class="bi bi-graph-up"></i>
                </span>
                <span class="description">Reports <i class="bi bi-caret-down-fill"></i></span>
            </a>
            <!--submenu for sales-->
            <div class="sub-menu collapse" id="submenu8">
                <a class="nav-link" href="profitlossonsoldproducts.php" target="iframe_a">
                    <span class="icon">
                        <i class="bi bi-bar-chart"></i>
                    </span>
                    <span class="description">Gross Profit</span>

                </a>
                <a class="nav-link" href="profitlossreport.php" target="iframe_a" >
                    <span class="icon">
                        <i class="bi bi-currency-dollar"></i>
                    </span>
                    <span class="description">Net Profit</span>

                </a>
                <a class="nav-link" href="value_on_hand.php" target="iframe_a">
                    <span class="icon">
                        <i class="bi bi-calculator"></i>
                    </span>
                    <span class="description">Grand Value</span>

                </a>

                <!--End of reports sub menu-->
            </div>



            <!--Settings menu with dropdown-->
            <a class="nav-link" href="#" data-bs-toggle="collapse" data-bs-target="#submenu9" aria-expanded="false" aria-controls="submenu9">
                <span class="icon">
                    <i class="bi bi-gear"></i>
                </span>
                <span class="description">Settings <i class="bi bi-caret-down-fill"></i></span>
            </a>
            <!--submenu for sales-->
            <div class="sub-menu collapse" id="submenu9">
                <a class="nav-link" href="banking.php" target="iframe_a">
                    <span class="icon">
                        <i class="bi bi-bank"></i>
                    </span>
                    <span class="description">Banking</span>

                </a>
                <a class="nav-link" href="backupdb.php" target="iframe_a" >
                    <span class="icon">
                        <i class="bi bi-box-arrow-up"></i>
                    </span>
                    <span class="description">Backup</span>

                </a>
               
                <!--End of settings sub menu-->
            </div>

            <!--Logout-->
            <a class="nav-link" href="logout.php">
                <span class="icon">
                    <i class="bi bi-plug"></i>
                </span>
                <span class="description">Logout</span>

            </a>
            <!--Logout-->



        
           

            
            
        </nav>
       
    </div>

  <!--  IFRAME      -->
<div class="main-content" id="main-content">
<iframe src="top_products_chart.php" style="border:none"; name="iframe_a" height="900px" width="100%" title="Iframe Example"></iframe>
</div>

<script>
  document.querySelectorAll('.nav-link').forEach(link => {
    link.addEventListener('click', function(e) {
      const page = this.getAttribute('data-page');

      if (page) {
        e.preventDefault(); // Only prevent default if we are fetching
        fetch(page)
          .then(response => {
            if (!response.ok) {
              throw new Error('Page not found');
            }
            return response.text();
          })
          .then(html => {
            document.getElementById('main-content').innerHTML = html;
          })
          .catch(error => {
            document.getElementById('main-content').innerHTML = '<p>Error loading page.</p>';
            console.error('Error:', error);
          });
      }
    });
  });
</script>
<script src="js/jquery.min.js"></script>
<script src="js/bootstrap.bundle.min.js"></script>

<script>
    let idleTime = 0;
    let idleInterval;
    let promptTimeout;
    let isPromptShown = false;

    function resetIdleTime() {
        idleTime = 0;
        if (isPromptShown) {
            hidePrompt();
        }
    }

    function showPrompt() {
        isPromptShown = true;
        const userResponse = confirm("You've been inactive for 2 minutes. Do you want to continue?");
        if (userResponse) {
            resetIdleTime(); // Reset if user wants to stay
        } else {
            window.location.href = 'logout.php'; // Logout if not
        }
    }

    function hidePrompt() {
        isPromptShown = false;
        clearTimeout(promptTimeout);
    }

    // Increment idle time every second
    idleInterval = setInterval(() => {
        idleTime++;
        if (idleTime === 120 && !isPromptShown) { // 2 minutes
            showPrompt();
        }
    }, 1000);

    // Reset on user activity
    ['mousemove', 'keydown', 'mousedown', 'touchstart'].forEach(event => {
        document.addEventListener(event, resetIdleTime, false);
    });
</script>
 


    
</body>
</html>