<?php
session_start();
if (!isset($_SESSION['username'])) {
    echo "<script>window.top.location.href='index.php';</script>"; // Redirect parent window to login page
    exit();
}

include 'connect.php';

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css">
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <title>CRUD OPERATION</title>
</head>
<body>
    <div class="container my-5">
      <div class="row">
        <div class="col-md-4 d-flex justify-content-center">
          <button class="btn btn-primary"><a href="insproducts.php" class="text-light">Add New Product<a></button>
        </div>
        <div class="col-md-4 d-flex justify-content-center">
          <form method="POST" action="pdf.php" target="_blank">
            <input type="submit" name="pdf_creator" value="PDF">
          </form>
        </div>
        <div class="col-md-4 d-flex justify-content-center">
          <form method="post" action="exportproducts.php">
            <button type="submit" name="export">Export to Excel</button>
          </form>
        </div>
      </div>
    </div>
    

    
    <div class="container my-5">
    <table class="table table-hover">
  <thead>
    <tr>
      <th scope="col">ProductID </th>
      <th scope="col">Product Name</th>
      <th scope="col">Product Code</th>
      <th scope="col">Product Price</th>
      <th scope="col">Product Cost</th>
      <th scope="col">Stock</th>
      
    </tr>
  </thead>
  <tbody>

  <?php
    $sql= "select * from products_table";
    $result= mysqli_query($conn,$sql);
    if($result){
       
        while($row=mysqli_fetch_assoc($result)){
            $product_id =$row['product_id'];
            $pr_Name=$row['pr_Name'];
            $product_number=$row['product_number'];
            $pr_Price=number_format($row['pr_Price']);
            $pr_Cost=number_format($row['pr_Cost']);
            $qty_Onhand=$row['qty_Onhand'];
            
            echo '<tr>
      <th scope="row">'.$product_id.'</th>
      <td>'.$pr_Name.'</td>
      <td>'.$product_number.'</td>
      <td>'.$pr_Price.'</td>
      <td>'.$pr_Cost.'</td>
      <td>'.$qty_Onhand.'</td>
      
      <td>
        <button class="btn btn-primary"><a href="updateproduct.php?updateid='.$product_id.'" class="text-light">Update<a></button>
        
    </td>
    </tr>';
            
        }

    }




   ?>
    
    
  </tbody>
</table>

    </div>
    
</body>
</html>