<?php
// deposit.php
require 'connect.php';

$total_balance = 0;
$success_message = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Remove commas from the amount for database storage
    $amount = str_replace(',', '', $_POST['amount']);
    $name = $_POST['name'];
    $purpose = $_POST['purpose'];

    // Insert the deposit transaction
    $sql = "INSERT INTO transactions (type, amount, name, purpose_usage) VALUES ('Deposit', '$amount', '$name', '$purpose')";

    if (mysqli_query($conn, $sql)) {
        // Calculate the total balance
        $balance_sql = "SELECT SUM(CASE WHEN type = 'Deposit' THEN amount ELSE -amount END) AS total_balance FROM transactions";
        $balance_result = mysqli_query($conn, $balance_sql);
        $balance_row = mysqli_fetch_assoc($balance_result);
        $total_balance = $balance_row['total_balance'];

        // Format the amount and total balance for display
        $formatted_amount = number_format($amount, 2, '.', ',');
        $formatted_balance = number_format($total_balance, 2, '.', ',');

        // Prepare the success message
        $success_message = "Deposit successful. Amount deposited: $formatted_amount. Total balance: $formatted_balance.";
    } else {
        echo "Error: " . $sql . "<br>" . mysqli_error($conn);
    }
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Deposit</title>
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <script>
        function confirmSubmission() {
            return confirm('Are you sure you want to deposit that amount?');
        }

        function formatNumber(input) {
            // Remove any non-digit characters except the decimal point
            let value = input.value.replace(/[^\d.]/g, '');

            // Split the value into integer and decimal parts
            let parts = value.split('.');
            let integerPart = parts[0];
            let decimalPart = parts.length > 1 ? parts[1] : '';

            // Format the integer part with thousand separators
            integerPart = integerPart.replace(/\B(?=(\d{3})+(?!\d))/g, ',');

            // Limit to two decimal places
            if (decimalPart.length > 2) {
                decimalPart = decimalPart.substring(0, 2);
            }

            // Combine the integer and decimal parts
            input.value = decimalPart ? integerPart + '.' + decimalPart : integerPart;
        }
    </script>
</head>
<body>
    <div class="container mt-5">
        <h2>Deposit Form</h2>
        <?php
        if (!empty($success_message)) {
            echo "<div class='alert alert-success' role='alert'>$success_message</div>";
        }
        ?>
        <form method="post" action="deposit.php" onsubmit="return confirmSubmission();">
            <div class="form-group">
                <label for="amount">Amount</label>
                <input type="text" class="form-control" id="amount" name="amount" onblur="formatNumber(this)" required>
            </div>
            <div class="form-group">
                <label for="name">Depositor Name</label>
                <input type="text" class="form-control" id="name" name="name" required>
            </div>
            <div class="form-group">
                <label for="purpose">Purpose of Money</label>
                <textarea class="form-control" id="purpose" name="purpose" rows="3" required></textarea>
            </div><br>
            <button type="submit" class="btn btn-primary">Deposit</button>
            <a href="banking.php" class="btn btn-secondary ml-2">Go Back</a>
        </form>
    </div>

    <!-- Bootstrap JS and dependencies -->
    <script src="js/jquery-3.3.1.slim.min.js"></script>
    <script src="js/popper.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
</body>
</html>
