<?php
session_start();

// Check if user is logged in
if (!isset($_SESSION['username'])) {
    header("Location: index.php");
    exit();
}

// Display username or other content
$username = $_SESSION['username'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Responsive Bootstrap 5</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-LN+7fdVzj6u52u30Kp6M/trliBMCMKTyK833zpbD+pXdCLuTusPj697FH4R/5mcr" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

    <link rel="stylesheet" href="stile.css">
</head>
<body>

    <div class="sidebar">
        <nav class="nav flex-column">
            <a class="nav-link" href="#" data-page="top_products_chart.php">
                <span class="icon">
                    <i class="bi bi-grid"></i>
                </span>
                <span class="description">Dashboard</span>

            </a>

            <!--products menu with dropdown-->
            <a class="nav-link" href="#" data-bs-toggle="collapse" data-bs-target="#submenu4" aria-expanded="false" aria-controls="submenu4">
                <span class="icon">
                    <i class="bi bi-cart"></i>
                </span>
                <span class="description">Products <i class="bi bi-caret-down-fill"></i></span>
            </a>
            <!--submenu for products-->
            <div class="sub-menu collapse" id="submenu4">
                <a class="nav-link" href="#" data-page="insproducts.php">
                    <span class="icon">
                        <i class="bi bi-box"></i>
                    </span>
                    <span class="description">Create Products</span>

                </a>
                <a class="nav-link" href="#" data-page="displayproducts.php">
                    <span class="icon">
                        <i class="bi bi-collection"></i>
                    </span>
                    <span class="description">Product Lists</span>

                </a>
                <!--End of products sub menu-->
            </div>
       

            <!--expense menu with dropdown-->
            <a class="nav-link" href="#" data-page="" data-bs-toggle="collapse" data-bs-target="#submenu3" aria-expanded="false" aria-controls="submenu3">
                <span class="icon">
                    <i class="bi bi-credit-card"></i>
                </span>
                <span class="description">Expense <i class="bi bi-caret-down-fill"></i></span>
            </a>
            <!--submenu for expenses-->
            <div class="sub-menu collapse" id="submenu3">
                <a class="nav-link" href="#" data-page="insertexpense.php">
                    <span class="icon">
                        <i class="bi bi-arrow-down-circle"></i>
                    </span>
                    <span class="description">Create Expense</span>

                </a>
                <a class="nav-link" href="#" data-page="displayexpense.php">
                    <span class="icon">
                        <i class="bi bi-receipt"></i>
                    </span>
                    <span class="description">Expenses List</span>

                </a>
                <!--End of expense sub menu-->
            </div>

            <!--purchase menu with dropdown-->
            <a class="nav-link" href="#" data-bs-toggle="collapse" data-bs-target="#submenu5" aria-expanded="false" aria-controls="submenu5">
                <span class="icon">
                    <i class="bi bi-bag"></i>
                </span>
                <span class="description">Purchase <i class="bi bi-caret-down-fill"></i></span>
            </a>
            <!--submenu for purchase-->
            <div class="sub-menu collapse" id="submenu5">
                <a class="nav-link" href="#" data-page="purchase.php">
                    <span class="icon">
                        <i class="bi bi-cart-plus"></i>
                    </span>
                    <span class="description">Create Purchase</span>

                </a>
                <a class="nav-link" href="#" data-page="viewpurchases.php">
                    <span class="icon">
                        <i class="bi bi-receipt"></i>
                    </span>
                    <span class="description">Purchase Lists (All)</span>

                </a>
                <a class="nav-link" href="#" data-page="viewpurchasescredit.php">
                    <span class="icon">
                        <i class="bi bi-tag-fill"></i>
                    </span>
                    <span class="description">Purchase Lists (Cr)</span>

                </a>
                <!--End of purchase sub menu-->
            </div>


             <!--sales menu with dropdown-->
            <a class="nav-link" href="#" data-page="" data-bs-toggle="collapse" data-bs-target="#submenu6" aria-expanded="false" aria-controls="submenu6">
                <span class="icon">
                    <i class="bi bi-currency-dollar"></i>
                </span>
                <span class="description">Sales <i class="bi bi-caret-down-fill"></i></span>
            </a>
            <!--submenu for sales-->
            <div class="sub-menu collapse" id="submenu6">
                <a class="nav-link" href="#" data-page="sell.php">
                    <span class="icon">
                        <i class="bi bi-cart-check"></i>
                    </span>
                    <span class="description">Create Sale</span>

                </a>
                <a class="nav-link" href="#" data-page="viewsells.php">
                    <span class="icon">
                        <i class="bi bi-trophy"></i>
                    </span>
                    <span class="description">Sales List (All)</span>

                </a>
                <a class="nav-link" href="#" data-page="viewsellscredit.php">
                    <span class="icon">
                        <i class="bi bi-bag-check"></i>
                    </span>
                    <span class="description">Sales List (Cr)</span>

                </a>

                <a class="nav-link" href="#" data-page="deletesale.php">
                    <span class="icon">
                        <i class="bi bi-x"></i>
                    </span>
                    <span class="description">Delete Sale</span>

                </a>
                <!--End of sales sub menu-->
            </div>


            
              <!--people menu with dropdown-->
            <a class="nav-link" href="#" data-bs-toggle="collapse" data-bs-target="#submenu7" aria-expanded="false" aria-controls="submenu7">
                <span class="icon">
                    <i class="bi bi-people"></i>
                </span>
                <span class="description">People <i class="bi bi-caret-down-fill"></i></span>
            </a>
            <!--submenu for sales-->
            <div class="sub-menu collapse" id="submenu7">
                <a class="nav-link" href="#" data-page="display.php">
                    <span class="icon">
                        <i class="bi bi-person-gear"></i>
                    </span>
                    <span class="description">Users List</span>

                </a>
                <a class="nav-link" href="#" data-page="display_customer.php">
                    <span class="icon">
                        <i class="bi bi-person-badge"></i>
                    </span>
                    <span class="description">Customers List</span>

                </a>
                <a class="nav-link" href="#" data-page="display_supplier.php">
                    <span class="icon">
                        <i class="bi bi-person-vcard"></i>
                    </span>
                    <span class="description">Suppliers List</span>

                </a>

                <!--End of people sub menu-->
            </div>



            <!--Reports menu with dropdown-->
            <a class="nav-link" href="#" data-bs-toggle="collapse" data-bs-target="#submenu8" aria-expanded="false" aria-controls="submenu8">
                <span class="icon">
                    <i class="bi bi-graph-up"></i>
                </span>
                <span class="description">Reports <i class="bi bi-caret-down-fill"></i></span>
            </a>
            <!--submenu for sales-->
            <div class="sub-menu collapse" id="submenu8">
                <a class="nav-link" href="#" data-page="profitlossonsoldproducts.php">
                    <span class="icon">
                        <i class="bi bi-bar-chart"></i>
                    </span>
                    <span class="description">Gross Profit</span>

                </a>
                <a class="nav-link" href="#" data-page="profitlossreport.php">
                    <span class="icon">
                        <i class="bi bi-currency-dollar"></i>
                    </span>
                    <span class="description">Net Profit</span>

                </a>
                <a class="nav-link" href="#" data-page="value_on_hand.php">
                    <span class="icon">
                        <i class="bi bi-calculator"></i>
                    </span>
                    <span class="description">Grand Value</span>

                </a>

                <!--End of reports sub menu-->
            </div>



            <!--Settings menu with dropdown-->
            <a class="nav-link" href="#" data-bs-toggle="collapse" data-bs-target="#submenu9" aria-expanded="false" aria-controls="submenu9">
                <span class="icon">
                    <i class="bi bi-gear"></i>
                </span>
                <span class="description">Settings <i class="bi bi-caret-down-fill"></i></span>
            </a>
            <!--submenu for sales-->
            <div class="sub-menu collapse" id="submenu9">
                <a class="nav-link" href="#" data-page="banking.php">
                    <span class="icon">
                        <i class="bi bi-bank"></i>
                    </span>
                    <span class="description">Banking</span>

                </a>
                <a class="nav-link" href="#" data-page="backup.php">
                    <span class="icon">
                        <i class="bi bi-box-arrow-up"></i>
                    </span>
                    <span class="description">Backup</span>

                </a>
               
                <!--End of settings sub menu-->
            </div>

            <!--Logout-->
            <a class="nav-link" href="logout.php">
                <span class="icon">
                    <i class="bi bi-plug"></i>
                </span>
                <span class="description">Logout</span>

            </a>
            <!--Logout-->



        
           

            
            
        </nav>
       
    </div>

    <main class="main-content" id="main-content">
        <h2>Responsive Sidebar Bootstrap 5</h2>
    </main>
  
    
<script>
  document.querySelectorAll('.nav-link').forEach(link => {
    link.addEventListener('click', function(e) {
      const page = this.getAttribute('data-page');

      if (page) {
        e.preventDefault(); // Only prevent default if we are fetching
        fetch(page)
          .then(response => {
            if (!response.ok) {
              throw new Error('Page not found');
            }
            return response.text();
          })
          .then(html => {
            document.getElementById('main-content').innerHTML = html;
          })
          .catch(error => {
            document.getElementById('main-content').innerHTML = '<p>Error loading page.</p>';
            console.error('Error:', error);
          });
      }
    });
  });
</script>

<script>
window.addEventListener("beforeunload", function() {
    navigator.sendBeacon('logout.php'); // Automatically log out when the window is closed
});
</script>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/js/bootstrap.bundle.min.js" integrity="sha384-ndDqU0Gzau9qJ1lfW4pNLlhNTkCfHzAVBReH9diLvGRem5+R9g2FzA8ZGN954O5Q" crossorigin="anonymous"></script>
</body>
</html>