<?php
include 'connect.php';

$term = isset($_POST['term']) ? $_POST['term'] : '';

$sql = "SELECT product_id, pr_Name, product_number, pr_Price, qty_Onhand 
        FROM products_table 
        WHERE pr_Name LIKE ? 
        ORDER BY pr_Name ASC 
        LIMIT 10";

$stmt = $conn->prepare($sql);
$like = "%$term%";
$stmt->bind_param("s", $like);
$stmt->execute();
$result = $stmt->get_result();

$suggestions = [];

while($row = $result->fetch_assoc()){
    $suggestions[] = [
        'label' => $row['pr_Name'],      // shown in dropdown
        'value' => $row['pr_Name'],      // inserted in input
        'id' => $row['product_id'],      // stored in hidden input
        'stock' => $row['qty_Onhand'],   // used to show current stock
        'code' => $row['product_number'],// display product code
        'price' => number_format($row['pr_Price'],2) // display price
    ];
}

echo json_encode($suggestions);
