<?php
include 'db.php';

if (isset($_GET['project_id'])) {
    $project_id = intval($_GET['project_id']);

    // Jumla ya makubaliano
    $agreed = $conn->prepare("SELECT SUM(agreed_amount) AS total_agreed FROM assignments WHERE project_id = ?");
    $agreed->bind_param("i", $project_id);
    $agreed->execute();
    $a = $agreed->get_result()->fetch_assoc();
    $agreed->close();

    // Jumla ya malipo yaliyofanyika
    $paid = $conn->prepare("SELECT SUM(amount) AS total_paid FROM assignment_payments ap JOIN assignments a ON ap.assignment_id = a.id WHERE a.project_id = ?");
    $paid->bind_param("i", $project_id);
    $paid->execute();
    $p = $paid->get_result()->fetch_assoc();
    $paid->close();

    $progress = 0;
    if ($a['total_agreed'] > 0) {
        $progress = ($p['total_paid'] / $a['total_agreed']) * 100;
    }

    $update = $conn->prepare("UPDATE projects SET progress = ? WHERE id = ?");
    $update->bind_param("di", $progress, $project_id);
    $update->execute();
    $update->close();

    echo json_encode(['success' => true, 'progress' => round($progress, 2)]);
}
?>
