<?php
// receipt.php
include 'db.php';

$payment_id = isset($_GET['payment_id']) ? intval($_GET['payment_id']) : 0;
if($payment_id <= 0){ echo "Invalid payment id"; exit; }

$sql = "SELECT ap.*, a.worker_name, a.task, a.agreed_amount, a.amount_paid AS total_paid_for_assignment, p.name AS project_name
        FROM assignment_payments ap
        JOIN assignments a ON ap.assignment_id = a.id
        JOIN projects p ON a.project_id = p.id
        WHERE ap.id = $payment_id LIMIT 1";
$res = $conn->query($sql);
if(!$res || $res->num_rows == 0){ echo "Payment not found"; exit; }
$row = $res->fetch_assoc();

$remaining = $row['agreed_amount'] - $row['total_paid_for_assignment'];
if($remaining < 0) $remaining = 0;

$office_name = "COLLATE ENTERPRISES"; // as you requested
$paid_at = date("Y-m-d H:i", strtotime($row['payment_date']));

// If TCPDF is installed and user requested server download, generate PDF server-side
$use_tcpdf = false;
if(isset($_GET['download']) && $_GET['download'] == '1'){
    if(file_exists(__DIR__ . '/tcpdf/tcpdf.php')){
        require_once(__DIR__ . '/tcpdf/tcpdf.php');
        $use_tcpdf = class_exists('TCPDF');
    }
}

if($use_tcpdf){
    // Create TCPDF receipt (80mm width)
    $pdf = new TCPDF('P', 'mm', array(80, 200), true, 'UTF-8', false);
    $pdf->SetMargins(5, 5, 5);
    $pdf->SetAutoPageBreak(TRUE, 5);
    $pdf->AddPage();

    // Logo (if exists)
    $logo = __DIR__ . '/logo.png';
    if(file_exists($logo)){
        $pdf->Image($logo, 25, 4, 30, '', '', '', 'T', false, 300);
    }

    $html = '<div style="text-align:center;font-weight:bold;font-size:12px;margin-top:6px;">' . htmlspecialchars($office_name) . '</div>';
    $html .= '<div style="text-align:center;font-size:10px;margin-bottom:6px;">PAYMENT RECEIPT</div>';
    $html .= '<table cellpadding="2" cellspacing="0" border="0" width="100%">';
    $html .= '<tr><td>Receipt #: </td><td align="right">' . $payment_id . '</td></tr>';
    $html .= '<tr><td>Date: </td><td align="right">' . $paid_at . '</td></tr>';
    $html .= '<tr><td>Project: </td><td align="right">' . htmlspecialchars($row['project_name']) . '</td></tr>';
    $html .= '<tr><td>Worker: </td><td align="right">' . htmlspecialchars($row['worker_name']) . '</td></tr>';
    $html .= '<tr><td>Task: </td><td align="right">' . htmlspecialchars($row['task']) . '</td></tr>';
    $html .= '<tr><td>Agreed: </td><td align="right">' . number_format($row['agreed_amount'],2) . '</td></tr>';
    $html .= '<tr><td>Paid (this): </td><td align="right">' . number_format($row['amount'],2) . '</td></tr>';
    $html .= '<tr><td>Total Paid: </td><td align="right">' . number_format($row['total_paid_for_assignment'],2) . '</td></tr>';
    $html .= '<tr><td>Remaining: </td><td align="right">' . number_format($remaining,2) . '</td></tr>';
    $html .= '</table>';
    $html .= '<div style="text-align:center;margin-top:8px;font-size:10px;">Thank you for your work!</div>';

    $pdf->writeHTML($html, true, false, true, false, '');
    // Output PDF to browser (force download)
    $pdf->Output('receipt_' . $payment_id . '.pdf', 'I');
    exit;
}

// Fallback: render print-friendly HTML and client-side PDF download (jsPDF)
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<title>Receipt #<?= $payment_id ?></title>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<link rel="stylesheet" href="assets/css/style.css">
<style>
/* narrow receipt style (80mm) */
body{font-family:monospace; margin:0; padding:8px; width:80mm; color:#000;}
.wrapper{width:100%;}
.header{text-align:center;margin-bottom:6px;}
.h1{font-weight:bold;font-size:14px;}
.small{font-size:11px;}
.separator{border-top:1px dashed #000; margin:6px 0;}
.item{display:flex;justify-content:space-between;margin:3px 0;}
.item .label{flex:1;} .item .value{width:95px;text-align:right;}
.center{text-align:center;}
</style>
</head>
<body>
<div class="wrapper">
  <div class="header">
    <?php if(file_exists(__DIR__.'/logo.png')): ?>
      <div style="text-align:center;"><img src="logo.png" alt="Logo" style="max-height:60px;"></div>
    <?php endif; ?>
    <div class="h1"><?= htmlspecialchars($office_name) ?></div>
    <div class="small">PAYMENT RECEIPT</div>
    <div class="small"><?= htmlspecialchars($row['project_name']) ?></div>
  </div>

  <div class="small">
    <div>Receipt #: <strong><?= $payment_id ?></strong></div>
    <div>Date: <?= $paid_at ?></div>
  </div>

  <div class="separator"></div>

  <div class="small">
    <div>Worker: <strong><?= htmlspecialchars($row['worker_name']) ?></strong></div>
    <div>Task: <?= htmlspecialchars($row['task']) ?></div>
  </div>

  <div class="separator"></div>

  <div class="item"><div class="label">Agreed Amount</div><div class="value"><?= number_format($row['agreed_amount'],2) ?></div></div>
  <div class="item"><div class="label">Amount Paid (this tx)</div><div class="value"><?= number_format($row['amount'],2) ?></div></div>
  <div class="item"><div class="label">Total Paid</div><div class="value"><?= number_format($row['total_paid_for_assignment'],2) ?></div></div>
  <div class="item"><div class="label">Remaining</div><div class="value"><?= number_format($remaining,2) ?></div></div>

  <div class="separator"></div>

  <div class="center small">Thank you for your work!</div>

  <div style="margin-top:8px;" class="no-print">
    <button onclick="window.print()">Print Receipt</button>
    <button onclick="downloadPDF()" style="margin-left:8px;">Download PDF</button>
    <button onclick="window.close()" style="margin-left:8px;">Close</button>
  </div>
</div>

<script>
function downloadPDF(){
    const { jsPDF } = window.jspdf;
    var doc = new jsPDF({unit:'mm', format:[80,200]});
    var content = document.querySelector('.wrapper').innerText;
    var lines = content.split('\n');
    var y = 5;
    doc.setFontSize(10);
    lines.forEach(function(line){
        doc.text(line.trim(), 5, y);
        y += 5;
    });
    doc.save('receipt_<?= $payment_id ?>.pdf');
}

// Auto-print when opened with &print=1
if(new URLSearchParams(window.location.search).get('print') === '1'){
    // small delay to render images
    setTimeout(()=>window.print(), 300);
}
</script>
</body>
</html>
