<?php
include 'db.php';

if(!isset($_GET['assignment_id'])){
    die("Assignment ID missing");
}

$assignment_id = intval($_GET['assignment_id']);

// Fetch assignment info
$stmt = $conn->prepare("SELECT a.id, a.worker_name, a.task, a.agreed_amount, a.amount_paid, p.name AS project_name 
                        FROM assignments a
                        LEFT JOIN projects p ON a.project_id = p.id
                        WHERE a.id=?");
$stmt->bind_param("i", $assignment_id);
$stmt->execute();
$assignment = $stmt->get_result()->fetch_assoc();
$stmt->close();

if(!$assignment){
    die("Assignment not found");
}

// Fetch payments
$stmt2 = $conn->prepare("SELECT amount, reference, payment_date FROM assignment_payments WHERE assignment_id=? ORDER BY payment_date ASC");
$stmt2->bind_param("i", $assignment_id);
$stmt2->execute();
$payments = $stmt2->get_result();
$stmt2->close();

$balance = $assignment['agreed_amount'] - $assignment['amount_paid'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Payment Receipt</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
body { font-family: Arial, sans-serif; background: #f0f0f0; padding: 10px; }
.receipt { width: 320px; margin: auto; background: #fff; padding: 15px; border: 1px solid #000; }
.header { text-align: center; margin-bottom: 10px; }
.header h2 { margin: 0; font-size: 18px; }
.header p { margin: 2px 0; font-size: 12px; }
.title { text-align: center; font-weight: bold; margin: 10px 0; }
.table { width: 100%; border-collapse: collapse; margin: 10px 0; }
.table th, .table td { border-bottom: 1px dashed #000; padding: 4px; font-size: 12px; }
.table th { text-align: left; }
.info p { margin: 2px 0; font-size: 12px; }
.footer { text-align: center; margin-top: 10px; font-size: 12px; }
.print-btn { width: 100%; padding: 8px; background: #0d6efd; color: #fff; border: none; border-radius: 5px; cursor: pointer; margin-top: 10px; }
.print-btn:hover { background: #084298; }
@media print {
    .print-btn { display: none; }
    body { background: #fff; padding: 0; }
}
</style>
</head>
<body>
<div class="receipt">
    <!-- Header -->
    <div class="header">
        <h2>COLLATE ENTERPRISES</h2>
        <p>Mbeya, Tanzania</p>
        <p>Payment Receipt</p>
    </div>

    <!-- Info -->
    <div class="info">
        <p><strong>Project:</strong> <?= htmlspecialchars($assignment['project_name']) ?></p>
        <p><strong>Fundi:</strong> <?= htmlspecialchars($assignment['worker_name']) ?></p>
        <p><strong>Task:</strong> <?= htmlspecialchars($assignment['task']) ?></p>
        <p><strong>Agreed Amount:</strong> Tshs. <?= number_format($assignment['agreed_amount'],2) ?></p>
        <p><strong>Total Paid:</strong> Tshs. <?= number_format($assignment['amount_paid'],2) ?></p>
        <p><strong>Balance:</strong> Tshs. <?= number_format($balance,2) ?></p>
    </div>

    <!-- Payments Table -->
    <table class="table">
        <thead>
            <tr>
                <th>Date</th>
                <th>Amount</th>
                <th>Ref</th>
            </tr>
        </thead>
        <tbody>
            <?php if($payments->num_rows>0): ?>
                <?php while($p = $payments->fetch_assoc()): ?>
                <tr>
                    <td><?= date("d-m-Y", strtotime($p['payment_date'])) ?></td>
                    <td><?= number_format($p['amount'],2) ?></td>
                    <td><?= htmlspecialchars($p['reference']) ?></td>
                </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr><td colspan="3" style="text-align:center;">No payments yet</td></tr>
            <?php endif; ?>
        </tbody>
    </table>

    <!-- Footer -->
    <div class="footer">
        <p>Thank you for your good work!</p>
        <p><?= date("d-m-Y H:i:s") ?></p>
    </div>

    <!-- Print Button -->
    <button class="print-btn" onclick="window.print()">Print Receipt</button>
</div>
</body>
</html>
