<?php
include 'db.php'; // DB connection
require('fpdf.php');

$office_name = "COLLATE ENTERPRISES";
$office_mobile = "+255 712 345 678";

session_start();

// ===== Handle form submissions =====

// Assign new fundi
if(isset($_POST['assign'])){
    $project_id = intval($_POST['project_id']);
    $worker_name = $_POST['worker_name'];
    $task = $_POST['task'];
    $agreed_amount = floatval($_POST['agreed_amount']);

    $stmt = $conn->prepare("INSERT INTO assignments (project_id, worker_name, task, agreed_amount) VALUES (?,?,?,?)");
    $stmt->bind_param("issi", $project_id, $worker_name, $task, $agreed_amount);
    $stmt->execute();
    $stmt->close();

    $_SESSION['success'] = "Fundi assigned successfully.";
    header("Location: ".$_SERVER['PHP_SELF']);
    exit();
}

// Make payment
if(isset($_POST['make_payment'])){
    $id = intval($_POST['id']);
    $amount = floatval($_POST['amount']);
    $reference = !empty($_POST['reference']) ? $_POST['reference'] : "CASH";

    $res = $conn->query("SELECT agreed_amount, amount_paid FROM assignments WHERE id=$id");
    if($res->num_rows==0){
        $_SESSION['error'] = "Assignment not found.";
        header("Location: ".$_SERVER['PHP_SELF']);
        exit();
    } else {
        $a = $res->fetch_assoc();
        $balance = $a['agreed_amount'] - $a['amount_paid'];
        if($amount > $balance){
            $_SESSION['error'] = "Payment cannot exceed balance of Tshs. ".number_format($balance,2);
            header("Location: ".$_SERVER['PHP_SELF']);
            exit();
        } else {
            $stmt = $conn->prepare("INSERT INTO assignment_payments (assignment_id, amount, reference) VALUES (?,?,?)");
            $stmt->bind_param("ids",$id,$amount,$reference);
            $stmt->execute();
            $stmt->close();

            $stmt2 = $conn->prepare("UPDATE assignments SET amount_paid = amount_paid + ? WHERE id=?");
            $stmt2->bind_param("di",$amount,$id);
            $stmt2->execute();
            $stmt2->close();

            $_SESSION['success'] = "Payment of Tshs. ".number_format($amount,2)." recorded successfully.";
            header("Location: ".$_SERVER['PHP_SELF']);
            exit();
        }
    }
}

// Delete assignment
if(isset($_POST['delete_assignment'])){
    $id = intval($_POST['id']);
    // Check if payment has been made
    $res = $conn->query("SELECT amount_paid FROM assignments WHERE id=$id");
    if($res->num_rows>0){
        $a = $res->fetch_assoc();
        if($a['amount_paid']>0){
            $_SESSION['error'] = "Cannot delete assignment. Payment has been made.";
            header("Location: ".$_SERVER['PHP_SELF']);
            exit();
        }
    }
    $stmt = $conn->prepare("DELETE FROM assignments WHERE id=?");
    $stmt->bind_param("i",$id);
    $stmt->execute();
    $stmt->close();

    $_SESSION['success'] = "Assignment deleted successfully.";
    header("Location: ".$_SERVER['PHP_SELF']);
    exit();
}

// Fetch assignments
$assignments = $conn->query("SELECT a.*, p.name AS project_name FROM assignments a LEFT JOIN projects p ON a.project_id=p.id ORDER BY a.id DESC");

$success = $_SESSION['success'] ?? null;
$error = $_SESSION['error'] ?? null;
unset($_SESSION['success'], $_SESSION['error']);
?>

<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Assignments</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
<style>
body { background:#f8f9fa; }
.container { margin-top:40px; }
.table th, .table td { vertical-align: middle; }
.scroll-btn { position: fixed; right: 25px; bottom: 25px; z-index: 999; display: flex; flex-direction: column; gap: 10px; }
.scroll-btn button { border: none; background-color: #0d6efd; color: white; border-radius: 50%; width: 45px; height: 45px; font-size: 22px; box-shadow: 0 4px 8px rgba(0,0,0,0.3); cursor: pointer; transition: all 0.3s ease; opacity: 0.85; }
.scroll-btn button:hover { transform: scale(1.1); opacity:1; }
.scroll-btn button.hidden { display:none; }
</style>
</head>
<body>
<div class="container">
<h2 class="mb-4">Project Assignments</h2>

<?php if($success): ?><div class="alert alert-success"><?= $success ?></div><?php endif; ?>
<?php if($error): ?><div class="alert alert-danger"><?= $error ?></div><?php endif; ?>

<!-- Assign Fundi Form -->
<div class="card mb-4">
<div class="card-header">Assign a Fundi</div>
<div class="card-body">
<form method="post" class="row g-2">
    <div class="col-md-3">
        <select name="project_id" class="form-control" required>
            <option value="">Select Project</option>
            <?php
            $projects = $conn->query("SELECT id, name FROM projects ORDER BY name ASC");
            while($p = $projects->fetch_assoc()){
                echo "<option value='{$p['id']}'>#{$p['id']} - ".htmlspecialchars($p['name'])."</option>";
            }
            ?>
        </select>
    </div>
    <div class="col-md-3"><input type="text" name="worker_name" class="form-control" placeholder="Fundi Name" required></div>
    <div class="col-md-3"><input type="text" name="task" class="form-control" placeholder="Task" required></div>
    <div class="col-md-2"><input type="number" step="0.01" name="agreed_amount" class="form-control" placeholder="Agreed Amount" required></div>
    <div class="col-md-1"><button type="submit" name="assign" class="btn btn-primary w-100">Assign</button></div>
</form>
</div>
</div>

<!-- Assignments Table -->
<div class="card">
<div class="card-header">Assignments List</div>
<div class="card-body table-responsive">
<table id="assignmentsTable" class="table table-bordered table-hover align-middle">
<thead class="table-dark">
<tr>
<th>#</th>
<th>Project</th>
<th>Fundi</th>
<th>Task</th>
<th>Agreed Amount</th>
<th>Paid</th>
<th>Balance</th>
<th>Progress</th>
<th>Actions</th>
</tr>
</thead>
<tbody>
<?php
if($assignments->num_rows>0){
    $sn=1;
    while($a=$assignments->fetch_assoc()){
        $balance=$a['agreed_amount']-$a['amount_paid'];
        $progress = $a['agreed_amount'] > 0 ? round(($a['amount_paid'] / $a['agreed_amount'])*100) : 0;
?>
<tr>
<td><?= $sn++; ?></td>
<td><?= htmlspecialchars($a['project_name']) ?> (#<?= $a['project_id'] ?>)</td>
<td><?= htmlspecialchars($a['worker_name']) ?></td>
<td><?= htmlspecialchars($a['task']) ?></td>
<td>Tshs. <?= number_format($a['agreed_amount'],2) ?></td>
<td>Tshs. <?= number_format($a['amount_paid'],2) ?></td>
<td>Tshs. <?= number_format($balance,2) ?></td>
<td><?= $progress ?>%</td>
<td>
<div class="dropdown">
<button type="button" class="btn btn-light btn-sm border-0" data-bs-toggle="dropdown">&#8942;</button>
<ul class="dropdown-menu dropdown-menu-end">
<li><a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#paymentModal<?= $a['id'] ?>">Make Payment</a></li>
<li><a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#viewModal<?= $a['id'] ?>">View</a></li>
<li><a class="dropdown-item" href="print_receipt.php?assignment_id=<?= $a['id'] ?>" target="_blank">🧾 Print Receipt</a></li>
<li><a class="dropdown-item text-primary" href="payment_report.php?assignment_id=<?= $a['id'] ?>" target="_blank">📊 Payment Report</a></li>
<li>
<?php if($a['amount_paid']>0): ?>
<button class="dropdown-item text-secondary" disabled>Cannot Delete (Paid)</button>
<?php else: ?>
<a class="dropdown-item text-danger" data-bs-toggle="modal" data-bs-target="#deleteModal<?= $a['id'] ?>">Delete</a>
<?php endif; ?>
</li>
</ul>
</div>
</td>
</tr>

<!-- Make Payment Modal -->
<div class="modal fade" id="paymentModal<?= $a['id'] ?>" tabindex="-1">
<div class="modal-dialog"><div class="modal-content">
<div class="modal-header"><h5 class="modal-title text-success">Make Payment</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
<div class="modal-body">
<form method="post" id="paymentForm<?= $a['id'] ?>">
<input type="hidden" name="id" value="<?= $a['id'] ?>">
<div class="mb-3"><label class="form-label">Fundi</label><input type="text" class="form-control" value="<?= htmlspecialchars($a['worker_name']) ?>" readonly></div>
<div class="mb-3"><label class="form-label">Amount to Pay (Tshs.)</label><input type="number" name="amount" class="form-control" max="<?= $balance ?>" required></div>
<div class="mb-3"><label class="form-label">Reference</label><input type="text" name="reference" class="form-control" placeholder="Optional (Cash if blank)"></div>
</form>
</div>
<div class="modal-footer">
<button type="submit" name="make_payment" class="btn btn-success" form="paymentForm<?= $a['id'] ?>" onclick="return confirm('Do you really want to make this payment?');">Submit Payment</button>
<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
</div>
</div></div></div>

<!-- View Modal -->
<div class="modal fade" id="viewModal<?= $a['id'] ?>" tabindex="-1">
<div class="modal-dialog"><div class="modal-content">
<div class="modal-header"><h5 class="modal-title">Assignment Details</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
<div class="modal-body">
<p><strong>Project:</strong> <?= htmlspecialchars($a['project_name']) ?> (#<?= $a['project_id'] ?>)</p>
<p><strong>Fundi:</strong> <?= htmlspecialchars($a['worker_name']) ?></p>
<p><strong>Task:</strong> <?= htmlspecialchars($a['task']) ?></p>
<p><strong>Agreed Amount:</strong> Tshs. <?= number_format($a['agreed_amount'],2) ?></p>
<p><strong>Paid:</strong> Tshs. <?= number_format($a['amount_paid'],2) ?></p>
<p><strong>Balance:</strong> Tshs. <?= number_format($balance,2) ?></p>
<p><strong>Progress:</strong> <?= $progress ?>%</p>
</div>
<div class="modal-footer"><button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button></div>
</div></div></div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal<?= $a['id'] ?>" tabindex="-1">
<div class="modal-dialog"><div class="modal-content">
<div class="modal-header"><h5 class="modal-title text-danger">Delete Assignment</h5><button type="button" class="btn-close" data-bs-dismiss="modal"></button></div>
<div class="modal-body">
<form method="post" id="deleteForm<?= $a['id'] ?>">
<input type="hidden" name="id" value="<?= $a['id'] ?>">
<p>Are you sure you want to delete this assignment?</p>
</form>
</div>
<div class="modal-footer">
<button type="submit" class="btn btn-danger" name="delete_assignment" form="deleteForm<?= $a['id'] ?>" onclick="return confirm('Are you sure you want to delete this assignment?');">Delete</button>
<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
</div>
</div></div></div>

<?php }} else { ?>
<tr>
<td colspan="9" class="text-center">No assignments found</td>
</tr>
<?php } ?>
</tbody>
</table>
</div>
</div>

<div class="text-center mt-4">
    <a href="index.php" class="btn btn-primary">Home</a>
    <a href="projects.php" class="btn btn-secondary me-2">Projects</a>
    <a href="budgets.php" class="btn btn-success">Budgets</a>
    <a href="#" class="btn btn-success">Logout</a>
</div>
</div>

<div class="scroll-btn">
  <button id="scrollUp" title="Scroll to Top" class="hidden">▲</button>
  <button id="scrollDown" title="Scroll to Bottom" class="hidden">▼</button>
</div>

<script>
$(document).ready(function(){
    $('#assignmentsTable').DataTable({
        "pageLength": 10,
        "order": [[0, "desc"]],
        "columnDefs": [{"orderable": false, "targets": 8}],
        "language": { "emptyTable": "No assignments found" }
    });
});

// Hide alerts after 5 seconds
setTimeout(() => {
    const alert = document.querySelector('.alert');
    if(alert){ alert.style.transition='opacity 0.5s'; alert.style.opacity='0'; setTimeout(()=>alert.remove(),500);}
},5000);

// Scroll buttons
const scrollUpBtn = document.getElementById("scrollUp");
const scrollDownBtn = document.getElementById("scrollDown");
window.addEventListener("scroll", () => {
  const scrollTop = window.scrollY || document.documentElement.scrollTop;
  const windowHeight = document.documentElement.scrollHeight - window.innerHeight;
  if(scrollTop>200) scrollUpBtn.classList.remove("hidden"); else scrollUpBtn.classList.add("hidden");
  if(scrollTop<windowHeight-200) scrollDownBtn.classList.remove("hidden"); else scrollDownBtn.classList.add("hidden");
});
scrollUpBtn.addEventListener("click", ()=>{ window.scrollTo({top:0,behavior:"smooth"}); });
scrollDownBtn.addEventListener("click", ()=>{ window.scrollTo({top:document.body.scrollHeight,behavior:"smooth"}); });
</script>
</body>
</html>
